/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import java.util.Set;
import org.jf.dexlib2.builder.BuilderDebugItem;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.LocatedDebugItems;
import org.jf.dexlib2.builder.LocatedItems;
import org.jf.dexlib2.builder.LocatedLabels;
import org.jf.dexlib2.builder.debug.BuilderEndLocal;
import org.jf.dexlib2.builder.debug.BuilderEpilogueBegin;
import org.jf.dexlib2.builder.debug.BuilderLineNumber;
import org.jf.dexlib2.builder.debug.BuilderPrologueEnd;
import org.jf.dexlib2.builder.debug.BuilderRestartLocal;
import org.jf.dexlib2.builder.debug.BuilderSetSourceFile;
import org.jf.dexlib2.builder.debug.BuilderStartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;

public class MethodLocation {
    BuilderInstruction instruction;
    int codeAddress;
    int index;
    private final LocatedItems<Label> labels;
    private final LocatedItems<BuilderDebugItem> debugItems = new LocatedDebugItems();

    MethodLocation(BuilderInstruction instruction, int codeAddress, int index) {
        this.labels = new LocatedLabels();
        this.instruction = instruction;
        this.codeAddress = codeAddress;
        this.index = index;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getCodeAddress() {
        return this.codeAddress;
    }

    void mergeInto(MethodLocation nextLocation) {
        this.labels.mergeItemsIntoNext(nextLocation, nextLocation.labels);
        this.debugItems.mergeItemsIntoNext(nextLocation, nextLocation.debugItems);
    }

    public Set<Label> getLabels() {
        return this.labels.getModifiableItems(this);
    }

    public Label addNewLabel() {
        Label newLabel = new Label();
        this.getLabels().add(newLabel);
        return newLabel;
    }

    public Set<BuilderDebugItem> getDebugItems() {
        return this.debugItems.getModifiableItems(this);
    }

    public void addLineNumber(int lineNumber) {
        this.getDebugItems().add(new BuilderLineNumber(lineNumber));
    }

    public void addStartLocal(int registerNumber, StringReference name, TypeReference type, StringReference signature) {
        this.getDebugItems().add(new BuilderStartLocal(registerNumber, name, type, signature));
    }

    public void addEndLocal(int registerNumber) {
        this.getDebugItems().add(new BuilderEndLocal(registerNumber));
    }

    public void addRestartLocal(int registerNumber) {
        this.getDebugItems().add(new BuilderRestartLocal(registerNumber));
    }

    public void addPrologue() {
        this.getDebugItems().add(new BuilderPrologueEnd());
    }

    public void addEpilogue() {
        this.getDebugItems().add(new BuilderEpilogueBegin());
    }

    public void addSetSourceFile(StringReference sourceFile) {
        this.getDebugItems().add(new BuilderSetSourceFile(sourceFile));
    }
}

